#ifndef __FUNCTION_H__
#define __FUNCTION_H__
#include "r.h"
#include <type_traits>
#include "lambda_trait.h"

template<typename T>
class DelegateBase
{
	public:
		typedef T ResultType;
		DelegateBase() { }
		virtual ~DelegateBase() { }
		virtual R<T> operator () () = 0;
};

template<typename T, typename T1>
class Delegate1Base
{
	public:
		typedef T ResultType;
		typedef T1 Arg1Type;
		Delegate1Base() { }
		virtual ~Delegate1Base() { }
		virtual R<T> operator () (R<T1> arg) = 0;
};

template<typename T, typename T1, typename T2>
class Delegate2Base
{
	public:
		typedef T ResultType;
		typedef T1 Arg1Type;
		typedef T2 Arg2Type;
		Delegate2Base() { }
		virtual ~Delegate2Base() { }
		virtual R<T> operator () (R<T1> arg1, R<T2> arg2) = 0;
};

template<typename T>
class FunBase : public DelegateBase<T>
{
	public:
		typedef R<T> (*FunType)();
		FunBase(FunType fun) : DelegateBase<T>(), fun(fun) { }
		virtual ~FunBase() { }
		virtual R<T> operator () () override { return fun(); }
	private:
		FunType fun;
};

template<typename T, typename TFun>
class FunLBase : public DelegateBase<T>
{
	public:
		typedef TFun FunType;
		FunLBase(FunType fun) : DelegateBase<T>(), fun(fun) { }
		virtual ~FunLBase() { }
		virtual R<T> operator () () override { return fun(); }
	private:
		FunType fun;
};

template<typename T, typename T1>
class Funx1Base : public DelegateBase<T>
{
	public:
		typedef R<T> (*FunType)(R<T1>);
		Funx1Base(FunType fun, R<T1> arg1) : DelegateBase<T>(), fun(fun), arg1(arg1) { }
		virtual ~Funx1Base() { }
		virtual R<T> operator () () override { return fun(arg1); }
	protected:
		FunType fun;
		R<T1> arg1;
};

template<typename T, typename T1, typename TFun>
class Funx1LBase : public DelegateBase<T>
{
	public:
		typedef TFun FunType;
		Funx1LBase(FunType fun, R<T1> arg1) : DelegateBase<T>(), fun(fun), arg1(arg1) { }
		virtual ~Funx1LBase() { }
		virtual R<T> operator () () override { return fun(arg1); }
	protected:
		FunType fun;
		R<T1> arg1;
};

template<typename T, typename T1, typename T2>
class Funx2Base : public DelegateBase<T>
{
	public:
		typedef R<T> (*FunType)(R<T1>, R<T2>);
		Funx2Base(FunType fun, R<T1> arg1, R<T2> arg2) : DelegateBase<T>(), fun(fun), arg1(arg1), arg2(arg2) { }
		virtual ~Funx2Base() { }
		virtual R<T> operator () () override { return fun(arg1, arg2); }
	protected:
		FunType fun;
		R<T1> arg1;
		R<T2> arg2;
};

template<typename T, typename T1, typename T2, typename TFun>
class Funx2LBase : public DelegateBase<T>
{
	public:
		Funx2LBase(TFun fun, R<T1> arg1, R<T2> arg2) : DelegateBase<T>(), fun(fun), arg1(arg1), arg2(arg2) { }
		virtual ~Funx2LBase() { }
		virtual R<T> operator () () override { return fun(arg1, arg2); }
	protected:
		TFun fun;
		R<T1> arg1;
		R<T2> arg2;
};

template<typename T, typename T1, typename T2, typename T3>
class Funx3Base : public DelegateBase<T>
{
	public:
		typedef R<T> (*FunType)(R<T1>, R<T2>, R<T3>);
		Funx3Base(FunType fun, R<T1> arg1, R<T2> arg2, R<T3> arg3) : DelegateBase<T>(), fun(fun), arg1(arg1), arg2(arg2), arg3(arg3) { }
		virtual ~Funx3Base() { }
		virtual R<T> operator () () override { return fun(arg1, arg2, arg3); }
	protected:
		FunType fun;
		R<T1> arg1;
		R<T2> arg2;
		R<T3> arg3;
};

template<typename T, typename T1, typename T2, typename T3, typename TFun>
class Funx3LBase : public DelegateBase<T>
{
	public:
		typedef TFun FunType;
		Funx3LBase(FunType fun, R<T1> arg1, R<T2> arg2, R<T3> arg3) : DelegateBase<T>(), fun(fun), arg1(arg1), arg2(arg2), arg3(arg3) { }
		virtual ~Funx3LBase() { }
		virtual R<T> operator () () override { return fun(arg1, arg2, arg3); }
	protected:
		FunType fun;
		R<T1> arg1;
		R<T2> arg2;
		R<T3> arg3;
};

/**** 1 arg ****/

template<typename T, typename T1>
class Fun1Base : public Delegate1Base<T, T1>
{
	public:
		typedef R<T> (*FunType)(R<T1>);
		Fun1Base(FunType fun) : Delegate1Base<T, T1>(), fun(fun) { }
		virtual ~Fun1Base() { }
		virtual R<T> operator() (R<T1> arg) override { return fun(arg); }
	protected:
		FunType fun;
};

template<typename T, typename T1, typename TFun>
class Fun1LBase : public Delegate1Base<T, T1>
{
	public:
		typedef TFun FunType;
		Fun1LBase(FunType fun) : Delegate1Base<T, T1>(), fun(fun) { }
		virtual ~Fun1LBase() { }
		virtual R<T> operator() (R<T1> arg) override { return fun(arg); }
	protected:
		FunType fun;
};

template<typename T, typename T1, typename TArg1>
class Fun1x1Base : public Delegate1Base<T, T1>
{
	public:
		typedef R<T> (*FunType)(R<TArg1>, R<T1>);
		Fun1x1Base(FunType fun, R<TArg1> arg1) : Delegate1Base<T, T1>(), fun(fun), arg1(arg1) { }
		virtual ~Fun1x1Base() { }
		virtual R<T> operator () (R<T1> arg) override { return fun(arg1, arg); }
	protected:
		FunType fun;
		R<TArg1> arg1;
};

template<typename T, typename T1, typename TArg1, typename TFun>
class Fun1x1LBase : public Delegate1Base<T, T1>
{
	public:
		typedef TFun FunType;
		Fun1x1LBase(FunType fun, R<TArg1> arg1) : Delegate1Base<T, T1>(), fun(fun), arg1(arg1) { }
		virtual ~Fun1x1LBase() { }
		virtual R<T> operator () (R<T1> arg) override { return fun(arg1, arg); }
	protected:
		FunType fun;
		R<TArg1> arg1;
};

/**** 2 args ****/

template<typename T, typename T1, typename T2>
class Fun2Base : public Delegate2Base<T, T1, T2>
{
	public:
		typedef R<T> (*FunType)(R<T1>, R<T2>);
		Fun2Base(FunType fun) : Delegate2Base<T, T1, T2>(), fun(fun) { }
		virtual ~Fun2Base() { }
		virtual R<T> operator() (R<T1> arg1, R<T2> arg2) override { return fun(arg1, arg2); }
	protected:
		FunType fun;
};

template<typename T, typename T1, typename T2, typename TFun>
class Fun2LBase : public Delegate2Base<T, T1, T2>
{
	public:
		typedef TFun FunType;
		Fun2LBase(FunType fun) : Delegate2Base<T, T1, T2>(), fun(fun) { }
		virtual ~Fun2LBase() { }
		virtual R<T> operator() (R<T1> arg1, R<T2> arg2) override { return fun(arg1, arg2); }
	protected:
		FunType fun;
};

/**** refrence specializations to add more functionality ****/
template <typename T>
class R<DelegateBase<T>, true> : public R<DelegateBase<T>, false>
{
	protected:
		// passing protected constructors
		inline R(int i) : R< DelegateBase<T>, false >(i) { }
	public:
		// passing public constructors
		inline R() : R< DelegateBase<T>, false>() { }
		template<typename U, bool od> inline R(R<U, od>& o) : R< DelegateBase<T>, false>(o, 0)
		{
			_assert_subclass<U, DelegateBase<typename U::ResultType>> ERRORBase; // U must be subclass of DelegateBase
			_assert_subclass<typename U::ResultType, T> ERRORItem; // result must be subclass of T
		}
		template<typename U, bool od> inline R(R<U, od>&& o) : R< DelegateBase<T>, false>(o, 0)
		{
			_assert_subclass<U, DelegateBase<typename U::ResultType>> ERRORBase; // U must be subclass of DelegateBase
			_assert_subclass<typename U::ResultType, T> ERRORItem; // result must be subclass of T
		}
		// passing operator=
		template<typename U, bool od> inline R< DelegateBase<T>, true >& operator=(R< DelegateBase<U>, od >&& o) { R< DelegateBase<T>, false >::operator=(o); return *this; }
		template<typename U, bool od> inline R< DelegateBase<T>, true >& operator=(R< DelegateBase<U>, od >& o) { R< DelegateBase<T>, false >::operator=(o); return *this; }
		// additional functionality
		inline R<T> operator() () { return this->deref()(); }
		// keep reference makeable with Ref::mk
		friend class Ref;
};

template <typename T, typename T1>
class R<Delegate1Base<T, T1>, true> : public R<Delegate1Base<T, T1>, false>
{
	protected:
		// passing protected constructors
		inline R(int i) : R< Delegate1Base<T, T1>, false >(i) { }
	public:
		// passing public constructors
		inline R() : R< Delegate1Base<T, T1>, false>() { }
		template<typename U, bool od> inline R(R<U, od>& o) : R< Delegate1Base<T, T1>, false>(o, 0)
		{
			_assert_subclass<U, Delegate1Base<typename U::ResultType, typename U::Arg1Type>> ERRORBase; // U must be subclass of DelegateBase
			_assert_subclass<typename U::ResultType, T> ERRORItem; // result must be subclass of T
			_assert_subclass<typename U::Arg1Type, T1> ERRORArg1; // result must be subclass of T
		}
		template<typename U, bool od> inline R(R<U, od>&& o) : R< Delegate1Base<T, T1>, false>(o, 0)
		{
			_assert_subclass<U, Delegate1Base<typename U::ResultType, typename U::Arg1Type>> ERRORBase; // U must be subclass of DelegateBase
			_assert_subclass<typename U::ResultType, T> ERRORItem; // result must be subclass of T
			_assert_subclass<typename U::Arg1Type, T1> ERRORArg1; // result must be subclass of T
		}
		// passing operator=
		template<typename U, typename U1, bool od> inline R< Delegate1Base<T, T1>, true >& operator=(R< Delegate1Base<U, U1>, od >&& o) { R< DelegateBase<T>, false >::operator=(o); return *this; }
		template<typename U, typename U1, bool od> inline R< Delegate1Base<T, T1>, true >& operator=(R< Delegate1Base<U, U1>, od >& o) { R< DelegateBase<T>, false >::operator=(o); return *this; }
		// additional functionality
		inline R<T> operator() (R<T1> arg1) { return this->deref()(arg1); }
		// keep reference makeable with Ref::mk
		friend class Ref;
};

template <typename T, typename T1, typename T2>
class R<Delegate2Base<T, T1, T2>, true> : public R<Delegate2Base<T, T1, T2>, false>
{
	protected:
		// passing protected constructors
		inline R(int i) : R< Delegate2Base<T, T1, T2>, false >(i) { }
	public:
		// passing public constructors
		inline R() : R< Delegate2Base<T, T1, T2>, false>() { }
		template<typename U, bool od> inline R(R<U, od>& o) : R< Delegate2Base<T, T1, T2>, false>(o, 0)
		{
			_assert_subclass<U, Delegate2Base<typename U::ResultType, typename U::Arg1Type, typename U::Arg2Type>> ERRORBase; // U must be subclass of DelegateBase
			_assert_subclass<typename U::ResultType, T> ERRORItem; // result must be subclass of T
			_assert_subclass<T1, typename U::Arg1Type> ERRORArg1; // arg must be superclass of T
			_assert_subclass<T2, typename U::Arg2Type> ERRORArg2; // arg must be superclass of T
		}
		template<typename U, bool od> inline R(R<U, od>&& o) : R< Delegate2Base<T, T1, T2>, false>(o, 0)
		{
			_assert_subclass<U, Delegate2Base<typename U::ResultType, typename U::Arg1Type, typename U::Arg2Type>> ERRORBase; // U must be subclass of DelegateBase
			_assert_subclass<typename U::ResultType, T> ERRORItem; // result must be subclass of T
			_assert_subclass<T1, typename U::Arg1Type> ERRORArg1; // arg must be superclass of T
			_assert_subclass<T2, typename U::Arg2Type> ERRORArg2; // arg must be superclass of T
		}
		// passing operator=
		template<typename U, typename U1, typename U2, bool od> inline R< Delegate2Base<T, T1, T2>, true >& operator=(R< Delegate2Base<U, U1, U2>, od >&& o) { R< DelegateBase<T>, false >::operator=(o); return *this; }
		template<typename U, typename U1, typename U2, bool od> inline R< Delegate2Base<T, T1, T2>, true >& operator=(R< Delegate2Base<U, U1, U2>, od >& o) { R< DelegateBase<T>, false >::operator=(o); return *this; }
		// additional functionality
		inline R<T> operator() (R<T1> arg1, R<T2> arg2) { return this->deref()(arg1, arg2); }
		// keep reference makeable with Ref::mk
		friend class Ref;
};

/**** type aliases ****/

template<typename T>
using Delegate = R< DelegateBase<T> >;

template<typename T, typename T1>
using Delegate1 = R< Delegate1Base<T, T1> >;

template<typename T, typename T1, typename T2>
using Delegate2 = R< Delegate2Base<T, T1, T2> >;

template<typename T>
using Fun = R< FunBase<T> >;

template<typename T, typename T1>
using Funx1 = R< Funx1Base<T, T1> >;

template<typename T, typename T1, typename T2>
using Funx2 = R< Funx2Base<T, T1, T2> >;

template<typename T, typename T1, typename T2, typename TFun>
using Funx2L = R< Funx2LBase<T, T1, T2, TFun> >;

template<typename T, typename T1, typename T2, typename T3>
using Funx3 = R< Funx3Base<T, T1, T2, T3> >;


template<typename T>
Delegate<T> mkFun(R<T> (*fun)())
{
	return Ref::mk< FunBase<T>, typename FunBase<T>::FunType >(fun);
}

template<typename TFun>
auto mkLFun(TFun fun) -> Delegate<typename decltype(fun())::etype>
{
	return Ref::mk<FunLBase<typename decltype(fun())::etype, TFun>> (fun);
}

template<typename T, typename T1>
Delegate<T> mkFun(R<T> (*fun)(R<T1>), R<T1> arg1)
{
	return Ref::mk< Funx1Base<T, T1>, typename Funx1Base<T, T1>::FunType, R<T1> >(fun, arg1);
}

template<typename T1, typename TFun>
auto mkLFun(TFun fun, R<T1> arg1) -> Delegate<typename decltype(fun(arg1))::etype>
{
	return Ref::mk<Funx1LBase<typename decltype(fun(arg1))::etype, T1, TFun>, TFun, R<T1>> (fun, arg1);
}

template<typename T, typename T1, typename T2>
Delegate<T> mkFun(R<T> (*fun)(R<T1>, R<T2>), R<T1> arg1, R<T2> arg2)
{
	return Ref::mk< Funx2Base<T, T1, T2>, typename Funx2Base<T, T1, T2>::FunType, R<T1>, R<T2> >(fun, arg1, arg2);
}

template<typename T1, typename T2, typename TFun>
auto mkLFun(TFun fun, R<T1> arg1, R<T2> arg2) -> Delegate<typename decltype(fun(arg1, arg2))::etype>
{
	return Ref::mk< Funx2LBase< typename decltype(fun(arg1, arg2))::etype, T1, T2, TFun>, TFun, R<T1>, R<T2> >(fun, arg1, arg2);
}

template<typename T, typename T1, typename T2, typename T3>
Delegate<T> mkFun(R<T> (*fun)(R<T1>, R<T2>, R<T3>), R<T1> arg1, R<T2> arg2, R<T3> arg3)
{
	return Ref::mk< Funx3Base<T, T1, T2, T3>, typename Funx3Base<T, T1, T2, T3>::FunType, R<T1>, R<T2>, R<T3> >(fun, arg1, arg2, arg3);
}

template<typename T1, typename T2, typename T3, typename TFun>
auto mkLFun(TFun fun, R<T1> arg1, R<T2> arg2, R<T3> arg3) -> Delegate<typename decltype(fun(arg1, arg2, arg3))::etype>
{
	return Ref::mk<Funx3LBase< typename decltype(fun(arg1, arg2, arg3))::etype, T1, T2, T3, TFun>, TFun, R<T1>, R<T2>, R<T3>>(fun, arg1, arg2, arg3);
}

/**** 1 arg ****/

template<typename T, typename T1>
Delegate1<T, T1> mkFun1(R<T> (*fun)(R<T1>))
{
	return Ref::mk< Fun1Base<T, T1>, typename Fun1Base<T, T1>::FunType >(fun);
}

template<typename TFun>
auto mkLFun1(TFun fun) -> Delegate1<typename lambdatype<TFun>::return_type::etype, typename lambdatype<TFun>::arg1_type::etype>
{
	return Ref::mk<Fun1LBase<typename lambdatype<TFun>::return_type::etype, typename lambdatype<TFun>::arg1_type::etype, TFun>, TFun>(fun);
}

template<typename T, typename T1, typename TArg1>
Delegate1<T, T1> mkFun1(R<T> (*fun)(R<TArg1>, R<T1>), R<T1> arg)
{
	return Ref::mk< Fun1x1Base<T, T1, TArg1>, typename Fun1x1Base<T, T1, TArg1>::FunType, R<T1> >(fun, arg);
}

template<typename TFun, typename TArg1>
auto mkLFun1(TFun fun, R<TArg1> arg1) -> Delegate1<typename lambdatype<TFun>::return_type::etype, typename lambdatype<TFun>::arg2_type::etype>
{
	return Ref::mk<Fun1x1LBase<typename lambdatype<TFun>::return_type::etype, typename lambdatype<TFun>::arg2_type::etype, TArg1, TFun>, TFun, R<TArg1>>(fun, arg1);
}

/**** 2 args ****/

template<typename T, typename T1, typename T2>
Delegate2<T, T1, T2> mkFun2(R<T> (*fun)(R<T1>, R<T2>))
{
	return Ref::mk< Fun2Base<T, T1, T2>, typename Fun2Base<T, T1, T2>::FunType >(fun);
}

template<typename TFun>
auto mkLFun2(TFun fun) -> Delegate2<typename lambdatype<TFun>::return_type::etype, typename lambdatype<TFun>::arg1_type::etype, typename lambdatype<TFun>::arg2_type::etype>
{
	return Ref::mk<Fun2LBase<typename lambdatype<TFun>::return_type::etype, typename lambdatype<TFun>::arg1_type::etype, typename lambdatype<TFun>::arg2_type::etype, TFun>, TFun>(fun);
}

#endif
