#ifndef __LAZY_H__
#define __LAZY_H__
#include "r.h"
#include "assert.h"
#include "delegate.h"
#include <functional>
#include <utility>
#include "lambda_trait.h"

// TODO: is case of simple function use typedef instead
template <typename T>
class LazyBase
{
//	_assert_subclass<TInit, DelegateBase<T>>
public:
	virtual ~LazyBase() { }
	bool isEvaluated() const
	{
		return !val.isNull();
	}
	void evaluate()
	{
		if (val.isNull())
		{
			val = fun();
			fun.free();
		}
	}
	R<T> get()
	{
		evaluate();
		return val;
	}
	explicit LazyBase(Delegate<T> fun) : fun(fun), val() { }
	friend R< LazyBase<T> > Ref::mk< LazyBase<T> >();
	friend R< LazyBase<Int> > suspend(Int val);
	friend R< LazyBase<UInt> > suspend(UInt val);
	template <typename U> friend R< LazyBase<U> > suspend(R<U> val);
	template <typename U, typename V> friend R< LazyBase<U> > suspendP(R<V> val);
private:
	explicit LazyBase() : fun(), val() { }

	Delegate<T> fun;
	R<T> val;
};

// specialize R definition for LazyBase to make lazy objects more useable
template <typename T>
class R< LazyBase<T>, true > : public R< LazyBase<T>, false >
{
	protected:
		// passing protected constructors
		inline R(int i) : R< LazyBase<T>, false >(i) { }
	public:
		// passing public constructors
		inline R() : R< LazyBase<T>, false>() { }
		template<typename U, bool od> inline R(R< LazyBase<U>, od >& o) : R< LazyBase<T>, false>(o, 0) { _assert_subclass<U, T> ERROR; }
		template<typename U, bool od> inline R(R< LazyBase<U>, od >&& o) : R< LazyBase<T>, false>(o, 0) { _assert_subclass<U, T> ERROR; }
		// passing operator=
		template<typename U, bool od> inline R< LazyBase<T>, true >& operator=(R< LazyBase<U>, od >&& o) { R< LazyBase<T>, false >::operator=(o); return *this; }
		template<typename U, bool od> inline R< LazyBase<T>, true >& operator=(R< LazyBase<U>, od >& o) { R< LazyBase<T>, false >::operator=(o); return *this; }
		// additional functionality
		inline T* operator->() { return &this->deref().get().deref(); }
		inline T& operator*() { return this->deref().get().deref(); }
		inline R<T> getR() { return this->deref().get(); }
		// keep reference makeable with Ref::mk
		friend class Ref;
};

template<typename T>
using Lazy = R< LazyBase<T> >;

template<typename T>
Lazy<T> mkLazy(Delegate<T> init)
{
	return Ref::mk< LazyBase<T> >(init);
}

/*template <typename T, typename TReal>
Lazy<T, TReal, FunBase<T, TReal> > mkLazy(typename FunBase<T, TReal>::FunType fun)
{
	return mkLazy(mkFun(fun));
}*/

template <typename T>
Lazy<T> mkLazy(R<T> (*fun)())
{
	return mkLazy<T>(mkFun(fun));
}

template <typename T>
R<T> lazyVal(Lazy<T> lval)
{
	return lval.deref().get();
}

template <typename T>
bool isEvaluated(R< LazyBase<T> > lval)
{
	return lval.deref().isEvaluated();
}

template <typename T>
Lazy<T> suspend(R<T> val)
{
	Lazy<T> l = Ref::mk< LazyBase<T> >();
	l.deref().val = val;
	return l;
}

Lazy<Int> suspend(Int i)
{
	auto l = Ref::mk< LazyBase<Int> >();
	l.deref().val = Ref::mk<Int, Int>(i);
	return l;
}

Lazy<UInt> suspend(UInt i)
{
	auto l = Ref::mk< LazyBase<UInt> >();
	l.deref().val = Ref::mk<UInt, UInt>(i);
	return l;
}

template <typename U, typename V>
Lazy<U> suspendP(R<V> val)
{
	Lazy<U> l = Ref::mk< LazyBase<U> >();
	l.deref().val = val;
	return l;
}

template <typename T>
T& operator*(LazyBase<T>& lval)
{
	return *(lval.get());
}

#include <iostream>


// moved to lazy_op.h
/*template <typename T>
class LazyOp
{
	private:
		static R<T> inc_inner(Lazy<T> i)
		{
			return Ref::mk<T, T>(lazyVal(i).deref() + 1);
		}
		static R<T> add_inner(Lazy<T> a, Lazy<T> b)
		{
			//std::cout << "adding : " << lazyVal(a).deref() << " + " << lazyVal(b).deref() << std::endl;
			return Ref::mk<T, T>(lazyVal(a).deref() + lazyVal(b).deref());
		}
		static R<T> sqr_inner(Lazy<T> x)
		{
			T val = lazyVal(x).deref();
			return Ref::mk<T, T>(val * val);
		}
	public:
		static Lazy<T> inc(Lazy<T> i)
		{
			auto fun = mkFun(&inc_inner, i);
			return mkLazy<T>(fun);
		}
		static Lazy<T> add(Lazy<T> a, Lazy<T> b)
		{
			auto fun = mkFun(&add_inner, a, b);
			return mkLazy<T>(fun);
		}
		static Lazy<T> sqr(Lazy<T> x)
		{
			return mkLazy<T>(mkFun(&sqr_inner, x));
		}
};*/

/*template <typename T>
class LazyOpR
{
	public:
		typedef LazyBase<Int> LazyInt
		lazyOpR()
		{
			rAdd = Ref::mk< Funx2Base<LazyInt, LazyInt, LazyInt>, Funx2Base<LazyInt, LazyInt, LazyInt>::FunType, R<LazyInt>, R<LazyInt> >(LazyOp::, arg1, arg2);
		}
		~lazyOpR() { }

		Funx2<LazyBase<Int>, LazyBase<Int>, LazyBase<Int>> rAdd;
};*/

/**** function lazification ****/
/*template<typename T>
Delegate<T> lazify(R<T> (*fun)())
{
	return mkFun([] (decltype(fun) fun) {
		return mkLazy(mkFun([] (decltype(fun) fun) {
			return fun();
		}, fun));
	}, fun);
}*/

/*template<typename T, typename T1>
Delegate<T> lazify(R<T> (*fun) (R<T1>))
{
	return mkFun1([] (decltype(fun) fun, Lazy<T1> arg1) {
		return mkLazy(mkFun([] (decltype(fun) fun, Lazy<T1> arg1) {
			return fun(arg1.getR());
		}, fun));
	}, fun);
}*/

template<typename TFun, int arg_count>
struct lazify_data;

template<typename TFun>
struct lazify_data<TFun, 0>
{
	typedef typename lambdatype<TFun>::return_type return_type;
	typedef Delegate<typename return_type::etype> delegate_type;
	typedef Delegate<LazyBase<typename return_type::etype>> ldelegate_type;
};

template<typename TFun>
struct lazify_data<TFun, 1>
{
	typedef typename lambdatype<TFun>::return_type return_type;
	typedef typename lambdatype<TFun>::arg1_type arg1_type;
	typedef Delegate1<typename return_type::etype, typename arg1_type::etype> delegate_type;
	typedef Delegate1<LazyBase<typename return_type::etype>, LazyBase<typename arg1_type::etype>> ldelegate_type;
};

template<typename TFun, int arg_count, typename TFunData>
class Lazify;

template<typename TFun, typename TFunData>
class Lazify<TFun, 0, TFunData>
{
	public:
		static auto doLazify(TFun fun) -> typename TFunData::ldelegate_type
		{
			return mkLFun([] (typename TFunData::delegate_type fun) {
				return mkLazy(mkLFun([] (typename TFunData::delegate_type fun) {
					return fun();
				}, fun));
			}, mkLFun(fun));
		}
};

template<typename TFun, typename TFunData>
class Lazify<TFun, 1, TFunData>
{
	public:
		static auto doLazify(TFun fun) -> typename TFunData::ldelegate_type
		{
			return mkLFun1([] (typename TFunData::delegate_type fun, Lazy<typename TFunData::arg1_type::etype> arg1) {
				return mkLazy(mkLFun([] (typename TFunData::delegate_type fun, Lazy<typename TFunData::arg1_type::etype> arg1) {
					return fun(arg1.getR());
				}, fun, arg1));
			}, mkLFun1(fun));
		}
};

template<typename TFun, int arg_count = lambdatype<TFun>::arg_count, typename TFunData = lazify_data<TFun, arg_count>>
auto lazify(TFun fun) -> typename TFunData::ldelegate_type
{
	return Lazify<TFun, arg_count, TFunData>::doLazify(fun);
}

#endif
