#ifndef __LAZY_OP_H__
#define __LAZY_OP_H__
#include "lazy.h"

template <typename T>
class LazyOp
{
	public:
		typedef Delegate1<LazyBase<T>, LazyBase<T>> D1;
		typedef Delegate2<LazyBase<T>, LazyBase<T>, LazyBase<T>> D2;

		static D1 inc;
		static D1 sqr;

		static D2 add;
	private:
		static D1 mkInc()
		{
			return mkLFun1([] (Lazy<T> x) {
				return mkLazy(mkLFun([] (Lazy<T> x) {
					return Ref::mk (*x + 1);
				}, x));
			});
		}
		static D1 mkSqr()
		{
			return mkLFun1([] (Lazy<T> x) {
				return mkLazy(mkLFun([] (Lazy<T> x) {
					auto val = *x;
					return Ref::mk (val*val);
				}, x));
			});
		}

		static D2 mkAdd()
		{
			return mkLFun2([] (Lazy<T> x, Lazy<T> y) {
				return mkLazy(mkLFun([] (Lazy<T> x, Lazy<T> y) {
					return Ref::mk (*x + *y);
				}, x, y));
			});
		}
};

template <typename T> typename LazyOp<T>::D1 LazyOp<T>::inc = LazyOp<T>::mkInc();
template <typename T> typename LazyOp<T>::D1 LazyOp<T>::sqr = LazyOp<T>::mkSqr();
template <typename T> typename LazyOp<T>::D2 LazyOp<T>::add = LazyOp<T>::mkAdd();

#endif
