#ifndef __R_H__
#define __R_H__
#include <exception>
#include "primitive.h"
#include "assert.h"
#include <type_traits>
#include <unordered_map>

class NullReference : public std::exception
{
	public:
		virtual const char* what() const throw() override { return "Trying to use null reference"; }
};

/*
 * Ahhoz hogy önhívatkozás működjön egyelőre egy hash_map-et
 * használjuk, későbbiékben majd vmi jobb megoldás, mert nagyon nem
 * teccik ez :)
 */
/*class RBase
{
	public:
		typedef std::unordered_map<const void*, long> map;
		inline RBase()
		{
		}
		inline void init()
		{
			instances.insert(map::value_type(ptr(), 0));
		}
		virtual ~RBase()
		{
			instances.erase(ptr());
		}
		inline bool isInitialized() const
		{
			return instances.end() != instances.find(ptr());
		};
	private:
		inline map::key_type ptr() const
		{
			return static_cast<map::key_type>(this);
		};
		static map instances;
};

RBase::map RBase::instances;*/

template <typename T, bool overridden = true>
class R //: public RBase
{
	public: // TODO: make protected
		struct VS // Value Structure
		{
			Int c;
			T* pVal;
			VS(Int c) : c(c) { }
		};

	protected:
		/*R<T>* stub;
		inline bool isStub()
		{

		}*/
		// ctor
		explicit R(int i) : vs(new VS(1))
		{
			// init();
		}
		// ctor (lvalue)
		template<typename U, bool od>
		R(R<U, od>& o, int i)
		{
			vs = reinterpret_cast<R<T, overridden>::VS*>(o.vs);
			cinc();
		}
		// ctor (rvalue)
		template<typename U, bool od>
		R(R<U, od>&& o, int i)
		{
			vs = reinterpret_cast<R<T, overridden>::VS*>(o.vs);
			cinc();
		}

	public:
		// element type
		typedef T etype;
		// def ctor
		R() : vs(nullptr)
		{
			// init();
		}
		// ctor
		template<typename U, bool od> R(R<U, od>& o)
		{
			_assert_subclass<U, T> ERROR;
			vs = reinterpret_cast<R<T, overridden>::VS*>(o.vs);
			cinc();
		}
		template<typename U, bool od> R(R<U, od>&& o)
		{
			_assert_subclass<U, T> ERROR;
			vs = reinterpret_cast<R<T, overridden>::VS*>(o.vs);
			cinc();
		}
		// dtor
		virtual ~R()
		{
			free();
		}
		template<typename U, bool od>
		R<T, od>& operator=(R<U, od>&& o)
		{
			_assert_subclass<U, T> ERROR;
			return copy(o);
		}
		template<typename U, bool od>
		R<T, od>& operator=(R<U, od>& o)
		{
			_assert_subclass<U, T> ERROR;
			return copy(o);
		}
	protected:
		template<typename U, bool od>
		inline R<T, od>& copy(R<U, od>& o)
		{
			// forceInit();
			if ((void*)&o != (void*)this)
			{
				free();
				vs = reinterpret_cast<R<T, overridden>::VS*>(o.vs);
				cinc();
			}
			return *reinterpret_cast< R<T, od>* >(this);
		}
		template<typename U, bool od>
		inline R<T, od>& copy(R<U, od>&& o)
		{
			// forceInit();
			if ((void*)&o != (void*)this)
			{
				free();
				vs = reinterpret_cast<R<T, overridden>::VS*>(o.vs);
				cinc();
			}
			return *reinterpret_cast< R<T, od>* >(this);
		}
	public:
		// freeing
		void free()
		{
			if (/*isInitialized() && */cdec() == 0) // TODO: Implement structural cycle freeing
			{
				delete vs->pVal;
				delete vs;
			}
			vs = nullptr;
		}
		// dereferencing
		inline T& deref()
		{
			ensure();
			return *vs->pVal;
		}
		inline Int refCount() const
		{
			ensure();
			return vs->c;
		}
		bool isNull() const
		{
			return vs == nullptr;
		}

		/*friend R<Int> mkR(Int i);
		template<typename U> friend R<U> mkR();
		template<typename U, typename UFirst> friend R<U> mkR(UFirst first);
		template<typename U, typename UFirst, typename USecond> friend R<U> mkR(UFirst first, USecond second);
		template<typename U, typename UFirst, typename USecond, typename UThird> friend R<U> mkR(UFirst first, USecond second, UThird third);
		template<typename U, typename UFirst, typename USecond, typename UThird, typename UFourth>
		friend R<U> mkR(UFirst first, USecond second, UThird third, UFourth fourth);*/
		friend class Ref;

		// operators
		inline T* operator->()
		{
			return &this->deref();
		}
		inline T& operator *()
		{
			return this->deref();
		}

	private:
		/*inline void forceInit()
		{
			if (!isInitialized())
			{
				RBase::init();
				vs = nullptr;
			}
		}*/
		inline void ensure() const
		{
			if (vs == nullptr)
			{
				throw NullReference();
			}
		}
		inline Int cinc()
		{
			if (vs != nullptr)
			{
				return ++vs->c;
			}
			else
			{
				return -1;
			}
		}
		inline Int cdec()
		{
			if (vs != nullptr)
			{
				return --vs->c;
			}
			else
			{
				return -1;
			}
		}
		// private data
	public: // TODO: make private
		VS* vs;

};

class Ref
{
	public:
		template <typename T>
		static R<T> mk()
		{
			R<T> ref(0);
			ref.vs->pVal = new T();
			return ref;
		}

		template <typename T, typename TFirst>
		static R<T> mk(TFirst first)
		{
			R<T> ref(0);
			ref.vs->pVal = new T(first);
			return ref;
		}

		template <typename T, typename TFirst, typename TSecond>
		static R<T> mk(TFirst first, TSecond second)
		{
			R<T> ref(0);
			ref.vs->pVal = new T(first, second);
			return ref;
		}

		template <typename T, typename TFirst, typename TSecond, typename TThird>
		static R<T> mk(TFirst first, TSecond second, TThird third)
		{
			R<T> ref(0);
			ref.vs->pVal = new T(first, second, third);
			return ref;
		}

		template <typename T, typename TFirst, typename TSecond, typename TThird, typename TFourth>
		static R<T> mk(TFirst first, TSecond second, TThird third, TFourth fourth)
		{
			R<T> ref(0);
			ref.vs->pVal = new T(first, second, third, fourth);
			return ref;
		}

		static R<Int> mk(Int i)
		{
			R<Int> ref(0);
			ref.vs->pVal = new Int(i);
			return ref;
		}
};

/**** specialize for base types ****/
template<>
class R<bool, true> : public R<bool, false>
{
	protected:
		inline R(int i) : R<bool, false>(i) { }
	public:
		inline R() : R<bool, false>() { }
		inline R(R<bool, true>&  o) : R<bool, false>(o, 0) { }
		inline R(R<bool, true>&& o) : R<bool, false>(o, 0) { }
		// additional ctor
		inline R(bool val) : R<bool, false>(0) { vs->pVal = new bool(val); }
		R<bool, true>& operator=(R<bool, true>&  o) { R<bool, false>::copy(o); return *this; }
		R<bool, true>& operator=(R<bool, true>&& o) { R<bool, false>::copy(o); return *this; }
		friend class Ref;
};

#endif
