#include <iostream>
#include "test_base.h"
#include "../primitive.h"
#include "../r.h"
#include "../lazy.h"
#include "../delegate.h"

Int cCount = 0;
Int dCount = 0;

class A
{
	public:
		A(Int i) : i(i) { ++cCount; }
		~A() { ++dCount; }
		Int i;
};

class B
{
	public:
		B(Int i) : i(i) { }
		virtual ~B() { }
		virtual Int getI() { return i; }
	protected:
		Int i;
};

class C : public B
{
	public:
		C(Int i) : B(i) { }
		virtual ~C() { }
		virtual Int getI() { return i + 1; }
};

void test();

int main()
{
	try
	{
		test();
		std::cout << "Test SUCCEEDED!" << std::endl;
	}
	catch (TestFailed& ex)
	{
		std::cout << "Failed" << std::endl << "Test FAILED: " << ex.what() << std::endl;
	}
	catch (...)
	{
		std::cout << "Failed" << std::endl << "Test FAILED with unknown exception" << std::endl;
	}
}

R<A> mkA()
{
	return Ref::mk<A> (10L);
}

void test()
{
	StringStream ss;
	std::cout << "Basic tests";

	auto la = mkLazy<A>(mkFun(&mkA));

	assertEq(0L, cCount, "Object should not have been created, but it has!");
	R<A> a = la.getR();
	assertEq(1L, cCount, "Object should have been created, but it has not!");
	R<A> b = la.getR();
	assertEq(1L, cCount, "Object should have been created only once, but it has not!");

	auto lb = mkLazy(mkLFun([] { return Ref::mk<A> (20L); }));

	assertEq(1L, cCount, "Object should not have been created, but it has!");
	a = lb.getR();
	assertEq(2L, cCount, "Object should have been created, but it has not!");
	b = lb.getR();
	assertEq(2L, cCount, "Object should have been created only once, but it has not!");

	auto lc = mkLazy<A>([]() { return Ref::mk<A> (30L);	});
	std::cout << "Success" << std::endl << "Polimorphism tests";
	auto ld = mkLazy<C>([]() { return Ref::mk<C, Int>(40L); });

	R<B> c = ld.getR();
	Int deref = c->getI();
	ss.empty() << "c.deref().getI() should return 41L but it returns " << deref;
	assertEq(41L, deref, ss.str());

	std::cout << "Success" << std::endl << "Closure tests";
	auto fun = mkLFun([] (R<Int> i) {
		++*i;
		return i;
	}, Ref::mk (1L));
	auto le = mkLazy(fun);
	auto lf = mkLazy(fun);
	ss.empty() << "*le should return 2L but it returns " << *le;
	assertEq(2L, *le, ss.str());
	ss.empty() << "*lf should return 3L but it returns " << *lf;
	assertEq(3L, *lf, ss.str());
	std::cout << "Success" << std::endl << "Lazifying tests";

	auto lfun = lazify([] () { return Ref::mk (20L); });
	Lazy<Int> lg = lfun();
	ss.empty() << "*lg should return 20L but it returns " << *lg;
	assertEq(20L, *lg, ss.str());

	auto lfun1 = lazify([] (R<Int> i) { return Ref::mk (*i + 20L); });
	Lazy<Int> lh = lfun1(lg);
	ss.empty() << "*lh should return 40L but it returns " << *lh;
	assertEq(40L, *lh, ss.str());

	std::cout << "Success" << std::endl;
}
