#include <iostream>
#include "test_base.h"
#include "../list.h"
#include "fib.h"
#include "../lazy_op.h"

void test();

int main()
{
	try
	{
		std::cout << "**** Testing lazy lists ****" << std::endl;
		test();
		std::cout << "Test SUCCEEDED!" << std::endl;
	}
	catch (TestFailed& ex)
	{
		std::cout << "Failed" << std::endl << "Test FAILED: " << ex.what() << std::endl;
	}
	catch (std::exception& ex)
	{
		std::cout << "Failed" << std::endl << "Test FAILED with std::exception: " << ex.what() << std::endl;
	}
	catch (...)
	{
		std::cout << "Failed" << std::endl << "Test FAILED with unknown exception" << std::endl;
	}
}

typedef Lazy<Int> (*IFun)(Lazy<Int>); 
typedef Lazy<Int> (*AFun)(Lazy<Int>, Lazy<Int>); 

Lazy<Int> add(Lazy<Int> a, Lazy<Int> b)
{
	return mkLazy(mkLFun([](Lazy<Int> a, Lazy<Int> b) { return Ref::mk (*a + *b); }, a, b));
}

void test()
{
	StringStream ss;
	std::cout << "Basic tests";
	// infinite list
	auto fib = mkFib();

	Int nth20 = *fib.drop(20).head();
	assertEq(nth20, 6765L, "20th fib must be 6765 and it is not!");
	Int nth30 = *fib.drop(30).head();
	assertEq(nth30, 832040L, "30th fib must be 832040 and it is not!");
	Int nth40 = *fib.drop(40).head();
	assertEq(nth40, 102334155L, "40th fib must be 102334155 and it is not!");

	// auto sqr = mkPFun1(&LazyOp<Int>::sqr);
	// auto inc = mkPFun1(&LazyOp<Int>::inc);
	// auto ascList = map(sqr, iterate(inc, suspend(0)));

	auto ascList = LazyList<Int>::iterate(LazyOp<Int>::inc, 0L);
	nth20 = *ascList.drop(20).head();
	nth30 = *ascList.drop(30).head();
	nth40 = *ascList.drop(40).head();
	assertEq(nth20, 20L, "20th item must be 20 and it is not!");
	assertEq(nth30, 30L, "30th item must be 30 and it is not!");
	assertEq(nth40, 40L, "40th item must be 40 and it is not!");

	auto sqrList = ascList.map(LazyOp<Int>::sqr);
	nth20 = *sqrList.drop(20).head();
	nth30 = *sqrList.drop(30).head();
	nth40 = *sqrList.drop(40).head();
	assertEq(nth20, 400L, "20th square must be 400 and it is not!");
	assertEq(nth30, 900L, "30th square must be 900 and it is not!");
	assertEq(nth40, 1600L, "40th square must be 1600 and it is not!");

	auto psqrList = ascList.filter(mkLFun1([] (Lazy<Int> i) -> R<bool> { return *i % 2 == 0; })).map(LazyOp<Int>::sqr);
	nth20 = *psqrList.drop(20).head();
	nth30 = *psqrList.drop(30).head();
	nth40 = *psqrList.drop(40).head();
	assertEq(nth20, 1600L, "20th square must be 1600 and it is not!");
	assertEq(nth30, 3600L, "30th square must be 3600 and it is not!");
	assertEq(nth40, 6400L, "40th square must be 6400 and it is not!");

	std::cout << "Success" << std::endl;
}
