#ifndef __TEST_COMMON_H__
#define __TEST_COMMON_H__


template<typename T>
void prints(const stream<T> &s, size_t n=10)
{
    typename stream<T>::iterator it=s.begin();
    for(size_t i=1; i<n; ++i) 
    {
        std::cout<<*it<<" ";
        ++it;
    }
    std::cout<<std::endl;
}

template<typename T>
void stress(const stream<T> &s)
{
    clock_t t1,t2;
    t1=clock();
    typename stream<T>::iterator it=s.begin();
    for(int i=1; i<10000; ++i) {
        *it;
        ++it;
    }
    t2=clock();
    std::cout<<(double(t2)-double(t1))/CLOCKS_PER_SEC<<std::endl;
}

template<typename T>
void compare(const stream<T> &s, const std::initializer_list<T> &a, int pass=3)
{

    typename stream<T>::iterator sit = s.begin();
    for(int i=0; i<pass; ++i)
    {
        typename std::initializer_list<T>::iterator ait = a.begin();

        while(ait != a.end())
        {
            assert(*ait==*sit);
            std::cout<<*ait<<" ";
            ++ait; ++sit;
        }
    }
    std::cout<<std::endl;
}

#endif//__TEST_COMMON_H__
