#include "stream.h"
#include "test_common.h"

template<typename T>
stream<int> helper(int x, T &&s)
{
    if(x==0) {
        return stream<int>(s);
	} else {
		--x;
        return helper(x, x<<=std::forward<T>(s));
	}
}

int main()
{
    stream<int> s =helper(1, s);
    stream<int> s1=helper(2, s1);
    stream<int> s2=helper(3, 9<<=s2);
    stream<int> s3=helper(0, 9<<=s3);
    stream<int> s4=helper(1, 9<<=s4);
    compare(s, {0});
    compare(s1, {0,1});
    compare(s2, {0,1,2,9});
    compare(s3, {9});
    compare(s4, {0,9});
}
