#include "stream.h"
#include "test_common.h"
#include <sys/time.h>

long timeval_diff(struct timeval &tv1, struct timeval &tv2)
{
    long ret = tv1.tv_usec - tv2.tv_usec;
    if(ret<0) ret += 1000000;
    return ret;
}


long fib(int n)
{
    long a=0,b=1;
    for(int i=0; i<n; ++i) {
        b+=a;
        a=b-a;
    }
    return a;
}


int main()
{
	stream<long> s = 0l<<=s+(1l<<=s);
    compare(s,  {0l,1l,1l,2l,3l,5l,8l,13l,21l,34l}, 1);

    const int n = 200000;
    struct timeval tv1, tv2;
    struct timezone tz;

    gettimeofday(&tv1, &tz);
    stream<long>::iterator it = s.begin();
    for(int i=0; i<n; ++i) ++it;
    *it; 
    gettimeofday(&tv2, &tz);
    std::cout<<timeval_diff(tv2, tv1)<<std::endl;

    gettimeofday(&tv1, &tz);
    fib(n);
    gettimeofday(&tv2, &tz);
    std::cout<<timeval_diff(tv2, tv1)<<std::endl;

	return 0;
}
