#ifndef __TEST_BASE_H__
#define __TEST_BASE_H__
#include <exception>
#include <string>
#include <sstream>

void assertTick();

class TestFailed : public std::exception
{
	public:
		TestFailed(const std::string& message) throw();
		virtual ~TestFailed() throw();
		virtual const char* what() const throw();
	private:
		std::string message;
};

template<typename T>
void assertEq(T val1, T val2, const std::string& errorMessage)
{
	if (val1 != val2)
	{
		throw TestFailed(errorMessage);
	}
	assertTick();
}

class StringStream : public std::stringstream
{
	public:
		StringStream& empty();
};

template<typename TException>
class assertException
{
	public:
		template<typename TFun>
		static void thrown(TFun fun, const std::string& errorMessage)
		{
			try
			{
				fun();
				throw TestFailed(errorMessage);
			}
			catch (TException& ex) {
				assertTick();
			}
		}
};
#endif
