{-# LANGUAGE FlexibleInstances #-}

module Ops where

import qualified Data.Supply as S
import Prelude (String, Int, ($), (.))
import qualified Prelude
import Lambda

class (Lambda l) => LOps l where
    infixop :: String -> Int -> (a -> b -> c) -> l a -> l b -> l c
    fun :: String -> a -> l a

    (+) :: l Int -> l Int -> l Int
    (+) = infixop "+" 4 (Prelude.+)

    (-) :: l Int -> l Int -> l Int
    (-) = infixop "-" 4 (Prelude.-)

    (*) :: l Int -> l Int -> l Int
    (*) = infixop "*" 5 (Prelude.*)


instance LOps Q where
    infixop _ _ f lhs rhs = Q (eval lhs `f` eval rhs)
    fun _ = Q

instance LOps S where
    fun name _ = S (\_ p -> Prelude.showsPrec p name)

    infixop name prec _ lhs rhs = S(\s p ->
        let (s1, s2) = S.split2 s
        in Prelude.showParen (p Prelude.> prec) $
            unS lhs s1 prec .
            Prelude.showString name .
            unS rhs s2 (Prelude.succ prec)
        )
