{-# LANGUAGE NoMonomorphismRestriction #-}

module Tests.OpsTest where

import Ops
import Lambda
import Prelude ( ($), Int, (==), return, sequence, (>>=), and, (.), IO, Bool )
import qualified Control.Monad

test1 :: (LOps l) => l Int
test1 = app (lam $ \x -> const 3 + x) (const 2)

test1ast :: IO Bool
test1ast = do
    t <- ast test1
    return $ t "" == "(λa.3+a) 2"
test1eval :: IO Bool
test1eval = return $ eval test1 == 5

tests :: [IO Bool]
tests = [ 
      test1ast
    , test1eval
    ]

runTests :: IO Bool
runTests = Control.Monad.liftM and $ sequence tests
