#ifndef __BINTREE_H__
#define __BINTREE_H__
#include "lazy.h"

template<typename T>
class BinTreeBase
{
	public:
		BinTreeBase(Lazy<BinTreeBase<T>> left, Lazy<T> val, Lazy<BinTreeBase<T>> right) : left(left), right(right), val(val) { }
		~BinTreeBase() { }

		Lazy<BinTreeBase<T>> getLeft() { return left; }
		Lazy<BinTreeBase<T>> getRight() { return right; }
		Lazy<T> get() { return val; }

	private:
		Lazy<BinTreeBase<T>> left;
		Lazy<BinTreeBase<T>> right;
		Lazy<T> val;
};

template<typename T>
using BinTree = Lazy<BinTreeBase<T>>;

#endif
