{-# LANGUAGE NoMonomorphismRestriction #-}

module Tests.SizeTest where

import Size
import Lambda
import Ops
import Prelude ( ($), Int, (==), return, sequence, (>>=), and, (.), IO, Bool )

testEmpty1 :: (Size l) => l [Unsized]
testEmpty1 = list (const 0) (lam $ \_ -> unsized)

testNil :: (Size l) => l [a]
testNil = list (const 0) (lam $ \_ -> bottom)

testHead :: (Size l) => l ([a] -> a)
testHead = slam $ \s f -> f `app` (s - const 1)

testTail :: (Size l) => l ([a] -> [a])
testTail = slam $ \s f -> list (s - const 1) f

testCons :: Size l => l (a -> [a] -> [a])
testCons = lam $ \x -> slam $ \s f ->
    list (s + const 1) $ shift f s (lam $ \_ -> x)
