{-# LANGUAGE NoMonomorphismRestriction #-}

module Tests.ExpTest where

import Lambda
import Exp
import Prelude ( ($), Int, (==), return, sequence, (>>=), and, (.), IO, Bool )
import qualified Control.Monad

testNil :: Exp e => e [a]
testNil = nil

testAddOne :: Exp e => e ([Int] -> [Int])
testAddOne = lam $ \l -> cons (const 1) l

testHead :: Exp e => e ([a] -> a)
testHead = lam $ \l -> match l undefined $ \x _ -> x

testTail :: Exp e => e ([a] -> [a])
testTail = lam $ \l -> match l undefined $ \_ xs -> xs

testConcat :: Exp e => e ([a] -> [a] -> [a])
testConcat = lam $ \l1 -> lam $ \l2 -> match l1 l2
    $ \x xs -> cons x (testConcat `app` xs `app` l2)

testEvalNil :: IO Bool
testEvalNil = return $ ([]::[Int]) == eval testNil

testEvalAddOne :: IO Bool
testEvalAddOne = return $ [1::Int] == (eval $ testAddOne `app` nil)

testEvalTail :: IO Bool
testEvalTail = return $ [2..6::Int] == eval testTail [1..6]

testEvalConcat :: IO Bool
testEvalConcat = return $ [1..6::Int] == eval testConcat [1,2,3] [4,5,6] 

tests :: [IO Bool]

tests = [ testEvalNil
        , testEvalAddOne
        , testEvalTail
        , testEvalConcat
        ]

runTests :: IO Bool
runTests = Control.Monad.liftM and $ sequence tests
