#ifndef __LAMBDA_TRAIT__
#define __LAMBDA_TRAIT__

template<int i>
struct lambdatype_args
{
	enum { value = i };
};

struct lambdatype_helper
{
	template<typename F, typename R, typename Arg1, typename Arg2, typename... Args>
	static auto arg2(R (F::*fun)(Arg1, Arg2, Args...) const) -> Arg2;

	template<typename F, typename R, typename Arg1, typename... Args>
	static auto arg1(R (F::*fun)(Arg1, Args...) const) -> Arg1;

	template<typename F, typename R, typename... Args>
	static auto result(R (F::*fun)(Args...) const) -> R;

	template<typename F, typename R, typename... Args>
	static lambdatype_args<sizeof...(Args)> arg_count(R (F::*fun)(Args...) const);
};

template<typename TFun>
struct lambdatype_base
{
	typedef decltype(lambdatype_helper::result(&TFun::operator())) return_type;
	enum { arg_count = decltype(lambdatype_helper::arg_count(&TFun::operator()))::value };
};

template<typename TFun, int i = lambdatype_base<TFun>::arg_count>
struct lambdatype;

template<typename TFun>
struct lambdatype<TFun, 0>
{
	typedef typename lambdatype_base<TFun>::return_type return_type;
	enum { arg_count = lambdatype_base<TFun>::arg_count };
};

template<typename TFun>
struct lambdatype<TFun, 1>
{
	typedef typename lambdatype_base<TFun>::return_type return_type;
	enum { arg_count = lambdatype_base<TFun>::arg_count };
	typedef decltype(lambdatype_helper::arg1(&TFun::operator())) arg1_type;
};

template<typename TFun>
struct lambdatype<TFun, 2>
{
	typedef typename lambdatype_base<TFun>::return_type return_type;
	enum { arg_count = lambdatype_base<TFun>::arg_count };
	typedef decltype(lambdatype_helper::arg1(&TFun::operator())) arg1_type;
	typedef decltype(lambdatype_helper::arg2(&TFun::operator())) arg2_type;
};

#endif
