#ifndef __FIB_H__
#define __FIB_H__
#include "../list.h"
#include "../lazy_op.h"

class FibBase : List<Int>
{
	public:
		virtual ~FibBase() { }

		virtual Lazy<Int> getHead() { return head; }
		virtual LazyList<Int> getTail()	{ return tail; }
		virtual bool isEmpty() { return false; }

		friend LazyList<Int> mkFib();
		friend R<FibBase> Ref::mk<FibBase>();
	private:
		FibBase() : List<Int>(), head(suspend((Int)0L)), tail() { }
		Lazy<Int> head;
		LazyList<Int> tail;
};

LazyList<Int> mkFib()
{
	static auto init = []
	{
		R<FibBase> fib  = Ref::mk<FibBase>();
		LazyList<Int> l = suspendP<List<Int>, FibBase>(fib);
		fib->tail       = zipWith(LazyOp<Int>::add, l, suspend((Int)1L) <<= l);
		return l;
	};
	static LazyList<Int> l = init();
	return l;
}


typedef R<FibBase> Fib;

#endif

