#ifndef __ASSERT_H__
#define __ASSERT_H__
#include <type_traits>

template <bool> class _assert;

template <> class _assert<true> { };

template<typename T, typename U, bool suppress = false>
class _assert_subclass
	: _assert<suppress || std::is_base_of<U, T>::value || std::is_same<U, T>::value>
{
};

#endif
